//##############################################################################
//    filename:        lcd_config.h
//##############################################################################
//    configuration file for LCD library (pins, voltage, delays ...)
//##############################################################################
//      Author:            	V.SchK
//      Company:        	HS-Ulm
//      Adapted:            AS
//      Revision:        	2.0 (for XC8)
//      Date:         		April 2020
//     	Compiler            XC8 v2.10
//      MPLAB X             v5.35
//      MCC                 v3.95
//##############################################################################

#ifndef _LCD_CONFIG_H
#define _LCD_CONFIG_H

#define LCD_TIMEOUT 100 /* should be 100*/

#define SPLC782A        // Select SPLC782A LCD CTRL delay template

// Check the LCD controller IC and adapt below delays
// Relies on delays provided by XC8 compiler library computed by MCC
//#warning "!!! LCD Delays depend upon your LCD module/controller !!!"
#if defined SPLC782A
    #define LongCommand2ms()    CORETIMER_DelayMs(4);     // depend upon LCD controller
    #define MiddleCommand40us() CORETIMER_DelayUs(200);    // depend upon LCD controller
    #define ShortDelay1us()     CORETIMER_DelayUs(200);     // depend upon LCD controller
    #define PowerupDelay()      CORETIMER_DelayMs(500);   // depend upon power supply
    #define DelayAfterPowerOn() CORETIMER_DelayMs(500);    // depend upon power supply    
    #define LCD_Delay_After_Reset() CORETIMER_DelayUs(50);     //actually ways 37
    #define LCD_Command_Delay() CORETIMER_DelayUs(50);     //actually ways 37
#endif

#define LCD_DELAY_1US()     CORETIMER_DelayUs(20); //ASO
#define LCD_DELAY_100US()   CORETIMER_DelayUs(500); //ASO
#define LCD_DELAY_5MS()     CORETIMER_DelayMs(20); //ASO
#define LCD_DELAY_15MS()    CORETIMER_DelayMs(60); //ASO


// uncomment the board in use or define a custom pinning ;-) --------------------

//    #define PICDEM2p_2002
//    #define PICDEM2p_2006
//    #define PICDEM2p_2010     //ASO
//    #define PIC_ADAPTER
//    #define EXT_LCD_3_3_V   //DOG... displays
//    #define EXT_LCD_5_V
//      #define Low_Ohms_Meter
      #define Digital_Preamp

//      custom boards at the end

    #if defined PICDEM2p_2002
        #warning "LCD-pinning for PICDEM2+ 2002 !!!"
        #define	LCD_E		LATAbits.LATA1
        #define	LCD_E_DIR	TRISAbits.TRISA1
        #define	LCD_RW		LATAbits.LATA2
        #define	LCD_RW_DIR	TRISAbits.TRISA2
        #define	LCD_RS		LATAbits.LATA3
        #define	LCD_RS_DIR	TRISAbits.TRISA3

        #define	LCD_D4_IN	PORTDbits.RD0
        #define	LCD_D5_IN	PORTDbits.RD1
        #define	LCD_D6_IN	PORTDbits.RD2
        #define	LCD_D7_IN	PORTDbits.RD3
        #define	LCD_D4_OUT	LATDbits.LATD0
        #define	LCD_D5_OUT	LATDbits.LATD1
        #define	LCD_D6_OUT	LATDbits.LATD2
        #define	LCD_D7_OUT	LATDbits.LATD3
        #define	LCD_D4_DIR	TRISDbits.TRISD0
        #define	LCD_D5_DIR	TRISDbits.TRISD1
        #define	LCD_D6_DIR	TRISDbits.TRISD2
        #define	LCD_D7_DIR	TRISDbits.TRISD3

    #elif defined(PICDEM2p_2006) || defined(PIC_ADAPTER)
        #warning "LCD-pinning for PICDEM2+ 2006 !!!"
        #define	LCD_E		LATDbits.LATD6
        #define	LCD_E_DIR	TRISDbits.TRISD6
        #define	LCD_RW		LATDbits.LATD5
        #define	LCD_RW_DIR	TRISDbits.TRISD5
        #define	LCD_RS		LATDbits.LATD4
        #define	LCD_RS_DIR	TRISDbits.TRISD4

        #define	LCD_D4_IN	PORTDbits.RD0
        #define	LCD_D5_IN	PORTDbits.RD1
        #define	LCD_D6_IN	PORTDbits.RD2
        #define	LCD_D7_IN	PORTDbits.RD3
        #define	LCD_D4_OUT	LATDbits.LATD0
        #define	LCD_D5_OUT	LATDbits.LATD1
        #define	LCD_D6_OUT	LATDbits.LATD2
        #define	LCD_D7_OUT	LATDbits.LATD3
        #define	LCD_D4_DIR	TRISDbits.TRISD0
        #define	LCD_D5_DIR	TRISDbits.TRISD1
        #define	LCD_D6_DIR	TRISDbits.TRISD2
        #define	LCD_D7_DIR	TRISDbits.TRISD3

    #elif defined(PICDEM2p_2010)
        #warning "LCD-pinning for PICDEM2+ 2010 !!!"
        #define	LCD_E		LATDbits.LATD6
        #define	LCD_E_DIR	TRISDbits.TRISD6
        #define	LCD_RW		LATDbits.LATD5
        #define	LCD_RW_DIR	TRISDbits.TRISD5
        #define	LCD_RS		LATDbits.LATD4
        #define	LCD_RS_DIR	TRISDbits.TRISD4

        #define	LCD_D4_IN	PORTDbits.RD0
        #define	LCD_D5_IN	PORTDbits.RD1
        #define	LCD_D6_IN	PORTDbits.RD2
        #define	LCD_D7_IN	PORTDbits.RD3
        #define	LCD_D4_OUT	LATDbits.LATD0
        #define	LCD_D5_OUT	LATDbits.LATD1
        #define	LCD_D6_OUT	LATDbits.LATD2
        #define	LCD_D7_OUT	LATDbits.LATD3
        #define	LCD_D4_DIR	TRISDbits.TRISD0
        #define	LCD_D5_DIR	TRISDbits.TRISD1
        #define	LCD_D6_DIR	TRISDbits.TRISD2
        #define	LCD_D7_DIR	TRISDbits.TRISD3
    #elif defined(Low_Ohms_Meter)
//        #warning "LCD-pinning for Low Ohms Meter"
        #define	LCD_E		LATBbits.LATB7
        #define	LCD_E_DIR	TRISBbits.TRISB7
        #define	LCD_RW		LATBbits.LATB6
        #define	LCD_RW_DIR	TRISBbits.TRISB6
        #define	LCD_RS		LATBbits.LATB5
        #define	LCD_RS_DIR	TRISBbits.TRISB5

        #define	LCD_D4_IN	PORTBbits.RB12
        #define	LCD_D5_IN	PORTBbits.RB13
        #define	LCD_D6_IN	PORTBbits.RB14
        #define	LCD_D7_IN	PORTBbits.RB15
        #define	LCD_D4_OUT	LATBbits.LATB12
        #define	LCD_D5_OUT	LATBbits.LATB13
        #define	LCD_D6_OUT	LATBbits.LATB14
        #define	LCD_D7_OUT	LATBbits.LATB15
        #define	LCD_D4_DIR	TRISBbits.TRISB12
        #define	LCD_D5_DIR	TRISBbits.TRISB13
        #define	LCD_D6_DIR	TRISBbits.TRISB14
        #define	LCD_D7_DIR	TRISBbits.TRISB15
    #elif defined(Digital_Preamp)
//        #warning "LCD-pinning for Low Ohms Meter"
        #define	LCD_E		LATCbits.LATC2
        #define	LCD_E_DIR	TRISCbits.TRISC2
        #define	LCD_RW		LATCbits.LATC1
        #define	LCD_RW_DIR	TRISCbits.TRISC1
        #define	LCD_RS		LATCbits.LATC0
        #define	LCD_RS_DIR	TRISCbits.TRISC0

        #define	LCD_D4_IN	PORTCbits.RC3
        #define	LCD_D5_IN	PORTCbits.RC4
        #define	LCD_D6_IN	PORTCbits.RC5
        #define	LCD_D7_IN	PORTCbits.RC6
        #define	LCD_D4_OUT	LATCbits.LATC3
        #define	LCD_D5_OUT	LATCbits.LATC4
        #define	LCD_D6_OUT	LATCbits.LATC5
        #define	LCD_D7_OUT	LATCbits.LATC6
        #define	LCD_D4_DIR	TRISCbits.TRISC3
        #define	LCD_D5_DIR	TRISCbits.TRISC4
        #define	LCD_D6_DIR	TRISCbits.TRISC5
        #define	LCD_D7_DIR	TRISCbits.TRISC6
    #else
        #error PLEASE SPECIFY LCD CONNECTIONS !
    #endif


  #ifdef PICDEM2p_2006
    #define LCD_ON      LATDbits.LATD7
    #define LCD_ON_DIR  TRISDbits.TRISD7
  #endif

  #ifdef PICDEM2p_2010
    #define LCD_ON      LATDbits.LATD7
    #define LCD_ON_DIR  TRISDbits.TRISD7
  #endif
#endif //_LCD_CONFIG_H
